;;=====Keybinding=====
(global-set-key (kbd "C-x C-f") 'ido-find-file)
(global-set-key (kbd "C-x C-b") 'ibuffer)
(global-set-key [f1] 'counsel-find-file)
(global-set-key [f2] 'ivy-switch-buffer)
(global-set-key [f3] 'ibuffer)
;;(global-set-key [f4] 'save-buffers-kill-terminal)
(global-set-key [f4] 'delete-frame)
(global-set-key [f5] 'quit-daemon)
;;(global-set-key [f5] 'save-buffer)
(global-set-key [C-f5] 'save-some-buffers)
(global-set-key [f6] 'kill-buffer)
(global-set-key [f7] (lambda () (interactive) (term "/bin/bash")))
(global-set-key [f8] 'magit-status)
(global-set-key [C-f8] 'magit-dispatch)
(global-set-key [f9] 'treemacs)
(global-set-key [C-f9] 'imenu-list-smart-toggle)
;;Window Size
(global-set-key [f10] 'enlarge-window-horizontally)
(global-set-key [C-f10] 'shrink-window-horizontally)

(global-set-key [f11] 'eval-buffer)
(global-set-key [C-f11] (lambda () (interactive)(load-file "~/.emacs.d/init.el")))
(global-set-key [f12] 'undo)

(defun quit-daemon()
  "优雅的关闭守护进程"
  (interactive)
  (defun is-only-frame-p ()
  "判断当前 frame 是否为唯一的 frame"
  (<= (length (frame-list)) 1))
  (if (is-only-frame-p)
      (save-buffers-kill-emacs)
    (progn
      (delete-frame)
      (save-buffers-kill-emacs))))
;;(global-set-key [C-f12] 'save-buffers-kill-emacs)
;;(global-set-key [C-f1] 'find-file-other-window)
;;(global-set-key [M-f2] 'split-window-horizontally)
(global-set-key [C-f2] 'split-window-vertically)
;;(global-set-key [f3] 'delete-other-windows)
(global-set-key [C-f3] 'delete-window)
;;(global-set-key [M-f3] 'kill-buffer)
(global-set-key [C-f4] 'kill-buffer)
;;(global-set-key [f4] 'other-window)
;(global-set-key [C-f5] 'display-buffer)
;;(global-set-key [(C-f5)] 'switch-to-buffer-other-window)
;;(global-set-key [C-f7] (lambda ()(interactive)(split-window-horizontally)(term "/bin/bash")))
;;(global-set-key [f9] 'enlarge-window)
;;(global-set-key [f10] 'sr-speedbar-toggle)
;(global-set-key [C-f11] 'dired)
;;(global-set-key [M-f11] 'speedbar)
;;(global-set-key [C-f12] 'load-file ~/.emacs)
(global-set-key [up] 'windmove-up)
(global-set-key [down] 'windmove-down)
(global-set-key [left] 'windmove-left)
(global-set-key [right] 'windmove-right)
;;(global-set-key [M-up] 'previous-buffer)
;;(global-set-key [M-down] 'next-buffer)
(global-set-key (kbd "C-c q") 'auto-fill-mode)
(global-set-key (kbd "M-+") 'text-scale-increase)
(global-set-key (kbd "M-_") 'text-scale-decrease)

;; =====awesome-tab key binding=====
(global-set-key [C-left] 'awesome-tab-backward-tab)
(global-set-key [C-right] 'awesome-tab-forward-tab)
(global-set-key (kbd "C->") 'awesome-tab-forward-group)
(global-set-key (kbd "C-<") 'awesome-tab-backward-group)

;; =====ivy=====
(global-set-key (kbd "M-x") 'counsel-M-x)
(global-set-key (kbd "C-x b") 'ivy-switch-buffer)
;(global-set-key (kbd "C-x C-b") 'counsel-ibuffer)
;;(global-set-key (kbd "C-s") 'swiper)
;;(global-set-key (kbd "C-x C-f") 'counsel-find-file)

;; ====magit====
;;(global-set-key (kbd "C-x g") 'magit-status)
;;(global-set-key (kbd "C-x M-g") 'magit-dispatch)
;;(global-set-key (kbd "C-,") 'magit-status)
;;(global-set-key (kbd "C-.") 'magit-dispatch)

;; ====imenu-list====
;(define-key treemacs-mode-map (kbd "as") 'treemacs-switch-workspace)

;; =====move-line=====
(global-set-key [M-up] 'move-line-up)
(global-set-key [M-down] 'move-line-down)

(defun move-line (&optional n)
  "Move current line N (1) lines up/down leaving point in place."
  (interactive "p")
  (when (null n)
    (setq n 1))
  (let ((col (current-column)))
    (beginning-of-line)
    (next-line 1)
    (transpose-lines n)
    (previous-line 1)
    (forward-char col)))
(defun move-line-up (n)
  "Moves current line N (1) lines up leaving point in place."
  (interactive "p")
  (move-line (if (null n) -1 (- n))))
(defun move-line-down (n)
  "Moves current line N (1) lines down leaving point in place."
  (interactive "p")
  (move-line (if (null n) 1 n)))


(message "Init-key...DONE")
(provide 'init-key)

;;; init-key.el ends here
