;;;=============================界面和全局设置=============================
;;(setq default-frame-alist ' ((height . 34)(width . 80)(alpha 95)));;打开时的默认宽度和透明度以及不在焦点时的透明度
;;(set-frame-parameter (selected-frame) 'alpha '(85 50))
;;  (add-to-list 'default-frame-alist '(alpha 85 50))

;; 启动时最大化
;;(setq initial-frame-alist (quote ((fullscreen . maximized))))
(add-to-list 'default-frame-alist '(fullscreen . maximized))
;; (split-window-right)
;; (other-window 1)
;; (split-window-below)
;;不显示启动画面
(setq inhibit-startup-screen t)
;;不显示启动信息
(setq gnu-inhibit-startup-message t)
;; 不显示 *scratch*
(defun remove-scratch-buffer ()
  (if (get-buffer "*scratch*")
      (kill-buffer "*scratch*")))
;;(add-hook 'after-init-hook 'remove-scratch-buffer)
;;(add-hook 'after-change-major-mode-hook 'remove-scratch-buffer)

;;不加载'default'库
(setq inhibit-default-init t)
;; 不显示缓冲区列表
(setq inhibit-startup-buffer-menu t)

(setq initial-major-mode 'emacs-lisp-mode)

;;(remove-hook 'kill-emacs-hook 'keyfreq-mustsave--do)))
;;(setq initial-buffer-choice (switch-to-buffer "*Messages*"))
;;使用X的剪贴板
(setq x-select-enable-clipboard t)
;;关闭Python-mode无法自动判断缩进的提示
(setq python-indent-guess-indent-offset-verbose nil)
;;光标闪烁
(blink-cursor-mode 1)
;;文件末尾换行符
(setq require-final-newline t)
;;(xterm-mouse-mode t)
;;粘贴于光标处,而不是鼠标指针处
(setq mouse-yank-at-point t)

;;自动补全括号
;;(require 'electric)
;;(electric-pair-mode t)
;;(electric-indent-mode t);智能缩进

;; 保存文件时不要询问,直接保存
(setq save-silently t)

;;值为nil或未设置时，如果当前行内容过长，则在显示到边界后自动切换到下一行显示。
;;但并未加入换行符，只是在新一行显示当前行内容。
;;(set-default 'truncate-lines t);关闭自动换行功能
(setq shell-file-name "/bin/bash")
;;(setq-default major-mode 'text-mode);转为模式为text-mode

;;当前行长度超过fill-coulmn值后，输入回车或者空格，则从上一个断开符号自动折行。
(setq-default fill-column 80);80个字符自动换行

;;(add-hook 'org-mode-hook 'turn-off-auto-fill);;关闭org-mode的auto-fill(自动折行)功能
;;(add-hook 'python-mode-hook 'turn-on-auto-fill)
;;(add-hook 'text-mode-hook 'turn-on-auto-fill)
;;be smart about file names in mini buffer
(file-name-shadow-mode t)
;;语法高亮
(global-font-lock-mode t)
(setq font-lock-maximum-decoration t);用最丰富的颜色显示
(setq frame-title-format "yoursaf@laptop-->%b");在标题栏显示文件完整路径
;;(setq-default line-spacing 0.2) ;;设置行距
(setq-default indent-tabs-mode nil);  TAB插入空格
(setq default-tab-width 4);tab4个字符宽度
;;(auto-image-file-mode t);;打开图片显示功能
(setq auto-save-default nil);关闭自动保存模式
(setq auto-save-list-file-prefix (concat user-emacs-directory ".auto-save-list/.saves-"))
(setq make-backup-files nil);;关闭自动备份功能
;;(setq backup-by-copying t);设定备份文件的方式为拷贝
(setq backup-directory-alist '(("." . "~/.backupemacs")));设置默认存放备份文件的目录
;;(ansi-color-for-comint-mode-on);eshell乱码
;;(windmove-default-keybindings);开启使用S+方向键选择window


(prefer-coding-system 'utf-8)
(set-default-coding-systems 'utf-8)
(set-terminal-coding-system 'utf-8)
(set-keyboard-coding-system 'utf-8)

;; Tramp Faster than the default scp
(setq tramp-default-method "ssh")
;(customize-set-variable 'ido-enable-tramp-completion nil)
;(customize-set-variable 'tramp-syntax 'simplified)

;; 用"y/n"替换"yes/no"
;;(defalias 'yes-or-no-p 'y-or-n-p)
(setopt use-short-answers t)
(setq auto-mode-alist (cons '("[^/]\\.dired$" . dired-virtual-mode)
                            auto-mode-alist))

;;==========字体设置==========

(cond
 ((eq system-type 'gnu/linux)
;;  (add-to-list 'default-frame-alist '(font . "SF Mono-12:Regular"))
  (add-to-list 'default-frame-alist '(font . "Fira Code-12:Regular"))
  (setq default-directory "~/"))
 ((eq system-type 'windows-nt)
;;  (add-to-list 'default-frame-alist '(font . "Roboto Mono-12"))
;;  (add-to-list 'default-frame-alist '(font . "Rec Mono Linear-12"))
;;  (add-to-list 'default-frame-alist '(font . "IBM Plex Mono-12"))
(add-to-list 'default-frame-alist '(font . "DM Mono-12:Regular"))
  (setq default-directory "D:/"));;测试字体
 )

;;=====汉字字体=====
;;(set-fontset-font "fontset-default" 'han "HarmonyOS Sans SC")
(set-fontset-font "fontset-default" 'han "LXGW WenKai Mono Lite")
;; =====org-bullets字体=====
(set-fontset-font t 'symbol "DejaVu Sans Mono")

;;(set-fontset-font
;; t
;; 'symbol
;; (cond
;;  ((eq system-type 'windows-nt)
;;   (cond
;;    ((member "DejaVu Sans Mono" (font-family-list)) "DejaVu Sans Mono 12")))
;;  ((eq system-type 'darwin)
;;   (cond
;;    ((member "Apple Symbols" (font-family-list)) "Apple Symbols")))
;;  ((eq system-type 'gnu/linux)
;;   (cond
;;    ((member "DejaVu Sans Mono" (font-family-list)) "DejaVu Sans Mono 12")))))


;;================================自动补全
(setq hippie-expand-try-functions-list
      '(
        try-expand-line ; 补全当前行
        try-expand-line-all-buffers
        try-expand-list ; 补全一个列表
        try-expand-list-all-buffers
        try-expand-dabbrev ; 搜索当前 buffer
        try-expand-dabbrev-visible ; 搜索当前可见窗口
        try-expand-dabbrev-all-buffers ; 搜索所有 buffer
        try-expand-dabbrev-from-kill ; 从 kill-ring 中搜索
        try-complete-file-name ; 文件名匹配
        try-complete-file-name-partially ; 文件名部分匹配
        try-complete-lisp-symbol ; 补全 lisp symbol
        try-complete-lisp-symbol-partially ; 部分补全 elisp symbol
        try-expand-whole-kill
        ))
(global-set-key [(meta ?/)] 'hippie-expand)
;;(global-set-key (kbd "M-/") #'hippie-expand)

(message "Init-global...DONE")
(provide 'init-global)

;;; init-global.el ends here
