;;; init.el --- My emacs config file.
;; Author: yoursaf <yoursaf@163.com>
;; Keywords: init.el
;; Version: 2.0.0
;; 2024-12-20

;; This file is not part of GNU Emacs.

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.

;; History
;; * 2.0.0 (2024-12-20)
;;      + 配置文件重排
;; 扩展:
;;      init-global
;;      init-key
;;      init-org:
;;          org
;;          org-publish
;;          org-tempo
;;          htmlize
;;          org-superstar
;;      init-python:
;;          python
;;          elpy
;; 插件：
;;      1. use-package
;;      2. color-theme
;;      3. treemacs
;;      4. diminish
;;      5. all-the-icons
;;      6. awesome-tab
;;      7. ibuffer
;;      8. electric
;;      9. ido-mode
;;      10.counsel
;;      11.ivy
;;      12.ivy-posframe
;;      13.company-mode
;;      14.company-box
;;      15.yasnippet
;;      16.imenu-list
;;      17.highlight-symbol
;;      18.indent-bars
;;      19.fvwm-mode
;;      20.desktop
;;      21.save-place
;;      22.recentf
;;      23.server
;;      24.tab-jump-out
;;      
;;; Code:

(let
    ((file-name-handler-alist nil))
  ;; (add-to-list 'load-path (expand-file-name (concat user-emacs-directory "/lisp")))
  (add-to-list 'load-path (expand-file-name "lisp" user-emacs-directory))
  (require 'package)
  (setq package-archives '(("gnu" . "http://mirrors.ustc.edu.cn/elpa/gnu/")
                           ("melpa" . "http://mirrors.ustc.edu.cn/elpa/melpa/")
                           ;;("org" . "http://mirrors.tuna.tsinghua.edu.cn/elpa/org/")
                           ("nongnu" . "https://mirrors.ustc.edu.cn/elpa/nongnu/")
                           ))
;;  (setq package-archives '(("gnu"   . "http://elpa.emacs-china.org/gnu/")
;;                           ("melpa" . "http://elpa.emacs-china.org/melpa/")
;;                          ("org" . "http://elpa.emacs-china.org/org/")))
  (package-initialize) 

;;;===============================插件设置===============================

  ;; ==========1.use-package==========
  (unless (package-installed-p 'use-package)
    (package-refresh-contents)
    (package-install 'use-package))
  ;;  (require 'init-global)
  ;;  (use-package init-theme)
  (use-package init-global)
  (use-package init-key)
  (use-package init-org)
  (use-package init-python)
  
  ;; ==========2.color-theme==========
  (use-package calm-forest-theme
    :config
    (setq custom-safe-themes t)
    (load-theme 'calm-forest t)
    (message "Loading Calm-forest-theme...DONE"))

;; ==========3.treemacs==========
  (use-package init-treemacs)
  
;;  (use-package init-misc
;;    :defer 1)

  ;; ==========dashboard==========
  ;; (use-package dashboard
  ;;   :ensure t
  ;;   :config
  ;;   ;; Set the title
  ;;   (setq dashboard-banner-logo-title "YoursAF InSide")
  ;;   ;; Set the banner
  ;;   (setq dashboard-startup-banner 'logo)
  ;;   ;; Value can be
  ;;   ;; 'official which displays the official emacs logo
  ;;   ;; 'logo which displays an alternative emacs logo
  ;;   ;; 1, 2 or 3 which displays one of the text banners
  ;;   ;; "path/to/your/image.gif", "path/to/your/image.png" or "path/to/your/text.txt" which displays whatever gif/image/text you would prefer
  ;;   ;; To disable shortcut "jump" indicators for each section, set
  ;;   (setq dashboard-show-shortcuts nil)
  ;;   (setq dashboard-items '((recents  . 10)
  ;;                           ))
  ;;   (setq dashboard-set-navigator t)
  ;;   (setq dashboard-set-heading-icons t);;显示图标
  ;;   (setq dashboard-set-file-icons t);;显示文件图标
  ;;   (setq dashboard-center-content t)
  ;;   (dashboard-modify-heading-icons '((recents . "file-text")
  ;;                                     (bookmarks . "book")))
  ;;   (setq dashboard-footer-messages '("Good good study,day day up!"))
  ;;   (setq dashboard-footer-icon (all-the-icons-octicon "dashboard"
  ;;                                                      :height 1.1
  ;;                                                      :v-adjust -0.05
  ;;                                                      :face 'font-lock-keyword-face))
  ;;   (setq initial-buffer-choice (lambda () (get-buffer-create "*dashboard*")))
  ;;   (dashboard-setup-startup-hook)
  ;;   )
;;    :diminish dashboard-mode
;;    (setq dashboard-startup-banner "/path/to/image")

  ;; ==========4. diminish==========
  (use-package diminish
    :ensure t
    :defer t
    :config
    (message "Loading Diminish...DONE"))

  ;; ==========5. all-the-icons==========
  (use-package all-the-icons
;;    :ensure t
;;;;    :preface
;;;;    (require 'init-icons)
;;;;    :if
;;;;    (display-graphic-p)
    :config
;;    
;;    ;;    (add-to-list 'all-the-icons-dir-icon-alist
;;    ;;                 '("media" all-the-icons-faicon "random" :height 1.0 :v-adjust -0.1 :face all-the-icons-dsilver))
;;    ;;  (setq all-the-icons-color-icons nil)
    (setq all-the-icons-faces t)
    (message "Loading All-the-icons...DONE"))

  ;; ==========6. awesome-tab==========
  (use-package awesome-tab
;;    :load-path "lisp/awesome-tab"
;;    :after
    ;;(:any calm-forest-theme all-the-icons)
;;    (:any all-the-icons)
    :config
    (awesome-tab-mode t)
    (add-hook 'server-after-make-frame-hook
              (lambda ()
                (setq awesome-tab-display-icon (display-graphic-p))))
    (when (not(display-graphic-p))
      (setq awesome-tab-display-icon nil))
    (setq frame-background-mode 'dark)
    (setq awesome-tab-show-tab-index t
          awesome-tab-height 130
          awesome-tab-icon-height 0.8
          awesome-tab-icon-v-adjust -0.1
          awesome-tab-dark-selected-foreground-color "green3"
          awesome-tab-dark-active-bar-color "SpringGreen"
          awesome-tab-dark-unselected-blend 0.8
          awesome-tab-terminal-dark-select-background-color "#888"
          awesome-tab-terminal-dark-select-foreground-color "#000"
;;          awesome-tab-active-bar-width 3
          )
    (message "Loading Awesome-tab...DONE"))

  ;; ==========7. ibuffer==========
  (use-package ibuffer
    :ensure t
    :defer t
    :config
    (fullframe ibuffer ibuffer-quit)
    (setq ibuffer-expert t
          ibuffer-show-empty-filter-groups nil
          ibuffer-filter-group-name-face 'font-lock-doc-face
        ;; 不显示最下方的摘要信息
        ;;           ibuffer-display-summary nil
        )
    (use-package init-ibuffer)
    (message "Loading Ibuffer...DONE"))

  ;; ==========8. electric自动补全括号==========
  (use-package electric
    :ensure t
    :defer 0
    :config
    (electric-pair-mode t)
    (electric-indent-mode t)
    (message "Loading Electric...DONE"))

  ;; ==========9. ido-mode==========
  (use-package ido
    :ensure t
    :defer t
    :config
    (ido-mode 1)
    (progn
      (make-local-variable 'ido-decorations)
      (setf (nth 2 ido-decorations) "\n"))
    ;; show any name that has the chars you typed
    (setq ido-enable-flex-matching t)
    ;; use current pane for newly opened file
    (setq ido-default-file-method 'selected-window)
    ;; use current pane for newly switched buffer
    (setq ido-default-buffer-method 'selected-window)
    ;; stop ido from suggesting when naming new file
    (define-key (cdr ido-minor-mode-map-entry) [remap write-file] nil)
    ;; ido save file
    (setq ido-save-directory-list-file (locate-user-emacs-file ".ido.last"))
    (message "Loading ido...DONE"))

  ;; ==========10.counsel==========
  (use-package counsel
    :ensure t
    :defer t
    :config
    (message "Loading Counsel...DONE"))

  ;; ==========11.ivy==========
  (use-package ivy
    :ensure t
;;    :bind ;;用绑定的按键和命令启动ivy。
;;    ("C-x b" . ivy-switch-buffer)
    ;;  ("M-x" . counsel-M-x)
    ;;  ("C-x C-b" . counsel-ibuffer)
    ;;  ("C-s" . swiper)
    ;;  ("C-x C-f" . counsel-find-file)
;;    :hook
;;    (after-change-major-mode . ivy-mode)
    :defer t
    :config
    (setq ivy-use-virtual-buffers t
          ivy-magic-tilde nil
          ivy-count-format "(%d/%d) "
          ivy-re-builders-alist '((t . ivy--regex-plus))
          ivy-dynamic-exhibit-delay-ms 150
          ivy-di1splay-style 'fancy)
    ;; ivy done as "ido"
    (define-key ivy-minibuffer-map (kbd "RET") #'ivy-alt-done)
    ;; ivy move select 
    (define-key ivy-minibuffer-map (kbd "<up>") #'ivy-previous-line-or-history)
    (define-key ivy-minibuffer-map (kbd "<down>") #'ivy-next-line-or-history)
    (ivy-mode 1)
    (message "Loading Ivy-mode...DONE")

    ;; ==========12.ivy-posframe==========
    (use-package ivy-posframe
      :ensure t
;;      :after (ivy)
      :if (display-graphic-p)
      :diminish (ivy-posframe-mode "ivy-p")
      :config
      (ivy-posframe-mode 1)      
      (setq ivy-posframe-width 85)
      (setq ivy-posframe-display-functions-alist '((t . ivy-posframe-display-at-window-bottom-left)))
      (message "Loading Ivy-posframe...DONE"))
    )
  ;;ivy-posframe窗口位置设置
  ;; (setq ivy-posframe-display-functions-alist '((t . ivy-posframe-display-at-point)))
  ;; (setq ivy-posframe-display-functions-alist '((t . ivy-posframe-display)))
  ;; (setq ivy-posframe-display-functions-alist '((t . ivy-posframe-display-at-frame-center)))
  ;; (setq ivy-posframe-display-functions-alist '((t . ivy-posframe-display-at-window-center)))
  
  ;;   ==========13.company-mode==========
  (use-package company
    :ensure t
    ;;    :after (:any ivy ido)
    :diminish
    (company-mode "COMP")
;;    :init
;;    (add-hook 'after-init-hook #'global-company-mode)
    :hook
    prog-mode
    :bind (:map company-active-map
                ("\e" . company-abort))
    :config
    (global-company-mode)
;;    (define-key company-active-map (kbd "<escape>") 'company-abort)
    (setq company-dabbrev-downcase nil
          ;; make previous/next selection in the popup cycles
          company-selection-wrap-around t
          ;; Some languages use camel case naming convention,
          ;; so company should be case sensitive.
          company-dabbrev-ignore-case nil
          ;; press M-number to choose candidate
          company-show-numbers t
          company-idle-delay 0.2
          company-clang-insert-arguments nil
          company-require-match nil
          company-ctags-ignore-case t
          company-tooltip-align-annotations t
          company-minimum-prefix-length 2
          ;;company-auto-complete t
          )
    (set-face-foreground 'company-tooltip "gray50")
    (set-face-background 'company-tooltip "gray20")
    (set-face-foreground 'company-tooltip-common "chocolate")
    (set-face-foreground 'company-tooltip-selection "lightgray")
    (set-face-background 'company-tooltip-selection "DodgerBlue4")
    (set-face-foreground 'company-tooltip-common-selection "#00C864")
;;    (set-face-background 'company-scrollbar-bg "darkgray")
;;    (set-face-background 'company-scrollbar-fg "black")
;;    (set-face-foreground 'company-tooltip-annotation "gray40")
;;    (set-face-foreground 'company-tooltip-annotation-selection "white")
;;    (set-face-foreground 'company-tooltip-search "red")
    (message "Loading Company-mode...DONE"))

;; ==========14.company-box==========
  (use-package company-box
    :ensure t
    :diminish
    (company-box-mode nil)
;;    :if window-system
    :hook
    (company-mode . company-box-mode)
    :config
    (setq company-box-icons-alist 'company-box-icons-all-the-icons)
    (setq company-box-doc-delay 1)
    (setq company-box-backends-colors
          '(
            (company-yasnippet . (:all "lime green" :selected (:background "lime green" :foreground "black"))))))

  ;; ==========15.yasnippet==========
  (use-package yasnippet
    :ensure t
    :hook
    ((prog-mode . yas-minor-mode)
     (org-mode . yas-minor-mode)
;;     (python-mode . yas-minor-mode)
     ;;     (emacs-lisp-mode . yas-minor-mode)
     )
    :config
;;  (add-hook 'org-mode-hook #'yas-minor-mode)
;;  (add-hook 'emacs-lisp-mode-hook #'yas-minor-mode)
;;  (add-hook 'python-mode-hook #'yas-minor-mode)
    (yas-reload-all)
    (message "Loading Yasnippet...DONE")
    (use-package yasnippet-snippets
      :ensure t
      :requires (yasnippet)
      :config
      (yas-global-mode t)
      (message "Loading Yasnippet-snippets...DONE")))
  
  ;; ==========16.imenu-list==========
  (use-package imenu-list
    :ensure t
    :defer t
    ;;    :hook
    ;;    (org-mode . imenu-list-minor-mode)
    :config
    (setq imenu-list-size 0.2)
    (message "Loading Imenu-list...DONE"))

  ;; ==========17.highlight-symbol==========
  (use-package highlight-symbol
    :ensure t
    :hook (prog-mode . highlight-symbol-mode)
    :bind
    (("M-n" . highlight-symbol-next)
     ("M-p" . highlight-symbol-prev)
     ("M-r" . highlight-symbol-query-replace))
    :config
    (setq highlight-symbol-idle-delay 0.2)
    (message "Loading highlight-symbol...DONE"))

  ;; ==========18.indent-bars==========  
  (use-package indent-bars
    :ensure t
    :hook (python-mode . indent-bars-mode)
    :config
    (setq
     indent-bars-color '("#4d4d4d")
     indent-bars-pattern "│"
;;     indent-bars-pattern "."     
     indent-bars-width-frac 0.25
     indent-bars-pad-frac 0.1
     indent-bars-color-by-depth nil
     indent-bars-prefer-character t
     indent-bars-highlight-current-depth '(:color "#999999" :blend 1)
     indent-bars-display-on-blank-lines nil)
    (indent-bars-reset)
    (message "Loading indent-bars...DONE"))
;;     indent-bars-color-by-depth '(:regexp "outline-\\([0-9]+\\)" :blend 0.4)
;;     indent-bars-color-by-depth '(:palette ("red" "cyan" "orange" "green") :blend 0.4)
;;  (use-package highlight-indent-guides
;;    :ensure t
;;    :hook (python-mode . highlight-indent-guides-mode)
;;    :config
;;;;    (highlight-indent-guides-mode 1)
;;    (setq highlight-indent-guides-auto-enabled nil)
;;    (setq highlight-indent-guides-method 'character)
;;    (setq highlight-indent-guides-responsive 'top)
;;    (setq highlight-indent-guides-delay 0)
;;    (custom-set-faces
;;     '(highlight-indent-guides-character-face ((t (:foreground "#4d4d4d"))))
;;     '(highlight-indent-guides-top-character-face ((t (:foreground "#999999"))))
;;     )
;;    (message "highlight-indent-guides...DONE")
;;    )
  
  ;; ==========19.fvwm-mode==========
  (use-package fvwm-mode
    :ensure t
    :defer t
    :config
    (message "Loading Fvwm-mode...DONE"))

  ;; ==========fullframe==========
  ;; (use-package fullframe
  ;;   :ensure t
  ;;   :config
  ;;   (fullframe magit-status magit-mode-quit-window)
  ;;   )

  ;; ==========magit==========
  ;; (use-package magit
  ;;   :ensure t
  ;;   :defer t
  ;;   :no-require t
  ;;   :config
  ;;   (message "Loading Magit...DONE")
  ;;   )

  ;; ==========20.desktop==========
  (use-package desktop
    ;;    :demand t
    :config
    (desktop-save-mode 1)
    (setq desktop-path (list user-emacs-directory)
          desktop-auto-save-timeout 600)
    (setq desktop-load-locked-desktop t);; don't popup dialog ask user, load anyway
    (setq desktop-restore-frames t)    ;; don't restore any frame
    (message "Loading Desktop...DONE"))

  ;; ==========21.save-place==========
  (use-package saveplace
    :defer 1
    ;; :hook
    ;; (after-change-major-mode . save-place-mode)
    :init
    (setq save-place-file (locate-user-emacs-file ".places"))
    :config
    (save-place-mode 1)
    (message "Loading Saveplace...DONE"))

  ;; ==========22.recentf==========
    (use-package recentf
      :defer 1
;;      :hook
;;      (after-init-hook . recentf-mode)
      :config
      (setq recentf-max-saved-items 500
            recentf-max-menu-items 15
            recentf-auto-cleanup 'never
            recentf-exclude '("/tmp/" "/ssh:" ".ido.last")
            recentf-save-file (locate-user-emacs-file ".recentf"))
      (message "Loading Recentf...DONE"))

    ;; ==========23.server==========
    (use-package server
      :defer 1
      :config
      (unless (server-running-p)
      (server-start))
      (message "Loading Emacs Server...DONE"))

    ;; ==========24.tab-jump-out==========
    (use-package tab-jump-out
      :ensure t
      :init
      (setq tab-jump-out-mode t)
      :defer 1
      :config
      (setq yas-fallback-behavior '(apply tab-jump-out 1))
      (message "Loading tab-jump-out...DONE"))

  ;; 检测Emacs的启动时间
  ;; Use a hook so the message doesn't get clobbered by other messages.
  (add-hook 'emacs-startup-hook
            (lambda ()
              (message "Emacs ready in %s with %d garbage collections."
                       (format "%.2f seconds"
                               (float-time
                                (time-subtract after-init-time before-init-time)))
                       gcs-done)))
  (setq initial-scratch-message (concat ";; I am the master of my fate! - "(capitalize user-login-name) " InSide\n"))

  )

;;; init.el ends here
(custom-set-variables
 ;; custom-set-variables was added by Custom.
 ;; If you edit it by hand, you could mess it up, so be careful.
 ;; Your init file should contain only one such instance.
 ;; If there is more than one, they won't work right.
 '(package-selected-packages
   '(highlight-symbol yasnippet-snippets virtualenv use-package treemacs tab-jump-out org-superstar org-bullets neotree markdown-mode ivy-posframe indent-bars imenu-list ibuffer-vc htmlize gnu-elpa-keyring-update fvwm-mode fullframe elpy diminish dashboard counsel company-box color-theme-sanityinc-tomorrow auto-complete all-the-icons)))
(custom-set-faces
 ;; custom-set-faces was added by Custom.
 ;; If you edit it by hand, you could mess it up, so be careful.
 ;; Your init file should contain only one such instance.
 ;; If there is more than one, they won't work right.
 )
