(setq frame-inhibit-implied-resize t ;; 不要缩放frame
      initial-major-mode 'fundamental-mode;; 默认用最简单的模式
 package-enable-at-startup nil
 package--init-file-ensured t);; 不要自动启用package

;; (when (or (featurep 'esup-child)
;;           (fboundp 'profile-dotemacs)
;;           (daemonp)
;;           (boundp 'startup-now)
;;           noninteractive)
;;   (setq package-enable-at-startup nil))

(defvar my-computer-has-smaller-memory-p nil
  "Installing&Compiling many packages could cost too much memory.")

;; @see https://www.reddit.com/r/emacs/comments/ofhket/further_boost_start_up_time_with_a_simple_tweak/
;; 10% speed up of startup for my configuration
(unless my-computer-has-smaller-memory-p
  (setq gc-cons-percentage 0.6)
  (setq gc-cons-threshold most-positive-fixnum)
  (setq gc-cons-threshold 100000000)
  )

;; 显示行号
(global-display-line-numbers-mode)
;;(global-linum-mode t)
;; 特定模式不显示行号
(defcustom display-line-numbers-exempt-modes
  '(vterm-mode eshell-mode shell-mode term-mode treemacs-mode)
  "Major modes on which to disable line numbers."
  :group 'display-line-numbers
  :type 'list
  :version "green")

(defun display-line-numbers--turn-on ()
  "Turn on line numbers except for certain major modes.
Exempt major modes are defined in `display-line-numbers-exempt-modes'."
  (unless (or (minibufferp)
              (member major-mode display-line-numbers-exempt-modes))
    (display-line-numbers-mode)))
;; 关闭工具栏
(tool-bar-mode -1)
;; 关闭菜单栏
(menu-bar-mode -1)
;; 显示列号
(column-number-mode)
;; 模式栏显示时间 
(display-time-mode)
;;显示时间和日期
(setq display-time-day-and-date t)
;;使用24小时格式显示时间
(setq display-time-24hr-format t)
;;禁用响铃
(setq visible-bell 0)
;;选中区域高亮
(transient-mark-mode 1)
;; 滚动栏右侧显示
;;(setq scroll-bar-mode (quote right))
;; 不显示滚动条
(scroll-bar-mode -1)
;;(set-scroll-bar-mode -1)
;;括号匹配
(show-paren-mode t)
;;只匹配括号
;;(setq show-paren-style 'parentheses)
;; 匹配括号内的内容
;;(setq show-paren-style 'expression)
;; 如括号两头在屏幕内可见，则只匹配括号。如不全部可见，刚匹配括号内的内容
(setq show-paren-style 'mixed)
;; 选中文本后输入文本会替换文本
(delete-selection-mode t)
;; 高亮显示当前行
(global-hl-line-mode)
;;高亮显示的颜色
;;(set-face-attribute hl-line-face nil :distant-foreground "#ffffff" :background "#1a4b77")
(set-face-attribute hl-line-face nil :background "#404040")
;;(set-face-attribute hl-line-face nil :distant-foreground "#ffffff" :background "#1f2430")

(provide 'early-init)
