(use-package treemacs
  :ensure t
  :defer t
  ;; :init
  ;; (treemacs)
  :bind (:map global-map 
              ("M-0"       . treemacs-select-window)
              ("C-x t b"   . treemacs-bookmark)
              ("C-x t C-t" . treemacs-find-file)
              ("C-x t M-t" . treemacs-find-tag)
              ;;:map treemacs-mode-map
              ;;("Ws" . treemacs-switch-workspace)
              ;;("We" . treemacs-edit-workspaces)
              ([mouse-1]   . treemacs-single-click-expand-action))
  :config
  (if (display-graphic-p)
      (treemacs-modify-theme "Default"
        :config
        (progn
          (treemacs-create-icon :icon (all-the-icons-octicon "repo" :height 1.1 :v-adjust -0.1 :face 'all-the-icons-lcyan) :extensions (root))
          (treemacs-create-icon :icon (all-the-icons-octicon "file-directory" :height 1.1 :v-adjust 0.0 :face 'all-the-icons-blue-alt) :extensions (dir-closed))
          (treemacs-create-icon :icon (all-the-icons-material "subdirectory_arrow_right" :height 0.9 :v-adjust -0.2 :face 'all-the-icons-lgreen) :extensions (dir-open))
          (treemacs-create-icon :icon (all-the-icons-icon-for-file "foo.el" :height 0.9 :v-adjust -0.1) :extensions ("el" "elc"))
          (treemacs-create-icon :icon (all-the-icons-icon-for-file "foo.org" :height 0.9 :v-adjust 0.0) :extensions ("org"))
          (treemacs-create-icon :icon (all-the-icons-icon-for-file "foo.py" :height 0.9 :v-adjust 0.0 :face 'all-the-icons-lyellow) :extensions ("py"))
;;          (treemacs-create-icon :icon (all-the-icons-icon-for-file (buffer-name)) :extensions ((char-to-string (file-name-extension (buffer-name))))
          )))

  (setq treemacs-collapse-dirs           (if treemacs-python-executable 3 0)
        treemacs-sorting                 'alphabetic-asc
        treemacs-follow-after-init       t
        ;;          treemacs-is-never-other-window   t
        treemacs-silent-filewatch        t
        treemacs-silent-refresh          t
        treemacs-show-hidden-files       nil
        treemacs-width                   25
        treemacs-space-between-root-nodes nil
        )
  (treemacs-follow-mode t)
  (treemacs-filewatch-mode t)
;;  (pcase (cons (not (null (executable-find "git")))
;;               (not (null (executable-find "python"))))
;;    (`(t . t)
;;     (treemacs-git-mode 'deferred))
;;    (`(t . _)
;;     (treemacs-git-mode 'simple)))

  (message "Loading Treemacs...DONE")
  )

;;(defvar treemacs-custom-elisp-icon  (all-the-icons-icon-for-file (if (buffer-file-name) (buffer-name))))
;;(defvar treemacs-custom-extension (file-name-extension (if (buffer-file-name)(buffer-name))))
;;(defvar treemacs-custom-elisp-icon (all-the-icons-icon-for-file "foo.el"))
;;(treemacs-define-custom-icon (if (equal (file-name-nondirectory (buffer-file-name)) (buffer-name))(all-the-icons-icon-for-file (buffer-name)))
;;                               (file-name-extension (buffer-name)))

;;(message "%s...DONE" (buffer-name))
(provide 'init-treemacs)

;;; init-treemacs.el ends here
