(use-package calm-forest-theme
  :config
  (message "Loading Calm-forest-theme...DONE")
  )

;; If you don't customize it, this is the theme you get.
(setq-default custom-enabled-themes '(calm-forest))
;;(setq-default custom-enabled-themes '(sanityinc-tomorrow-eighties))

;; Don't prompt to confirm theme safety. This avoids problems with
;; first-time startup on Emacs > 26.3.
(setq custom-safe-themes t)

(defun reapply-themes ()
  "Forcibly load the themes listed in `custom-enabled-themes'."
  (dolist (theme custom-enabled-themes)
    (unless (custom-theme-p theme)
      (load-theme theme)))
  (custom-set-variables `(custom-enabled-themes (quote ,custom-enabled-themes))))

(add-hook 'after-init-hook 'reapply-themes)

(defun t-calm ()
  "Activate a day color theme."
  (interactive)
  (setq custom-enabled-themes '(calm-forest))
  (reapply-themes))

(defun t-day ()
  "Activate a day color theme."
  (interactive)
  (setq custom-enabled-themes '(sanityinc-tomorrow-day))
  (reapply-themes))

(defun t-eighties ()
  "Activate a eighties color theme."
  (interactive)
  (setq custom-enabled-themes '(sanityinc-tomorrow-eighties))
  (reapply-themes))

(defun t-night ()
  "Activate a night color theme."
  (interactive)
  (setq custom-enabled-themes '(sanityinc-tomorrow-night))
  (reapply-themes))

(message "Init-theme...DONE")
(provide 'init-theme)

;;; init-theme.el ends here
