;; ==========python-mode==========
(use-package python
  :defer t
  :mode ("\\.py\\'" . python-mode)
  :interpreter ("python" . python-mode)
  :bind
  (:map python-mode-map
        ([f2] . elpy-shell-send-region-or-buffer))
  :config
  (message "Loading Python-mode...DONE"))

;; ==========elpy==========
(use-package elpy
  :ensure t
  :defer t
  :init
  (advice-add 'python-mode :before 'elpy-enable)
;;    :hook
;;    (python-mode . elpy-mode)
  :config
  (cond
   ((eq system-type 'gnu/linux)
    (pyvenv-activate "~/python/")
    (setq elpy-rpc-virtualenv-path 'current))
   ((eq system-type 'windows-nt)
    (pyvenv-activate "D:/PythonProject/")
    (setq explicit-shell-file-name "C:/Program Files/Git/usr/bin/bash.exe"
          shell-file-name "bash.exe"
          python-shell-interpreter "python"
          elpy-rpc-virtualenv-path 'current
          elpy-rpc-python-command "D:/PythonProject/Scripts/python.exe")
    ))
  (message "Loading Elpy...DONE"))
;;    python-shell-interpreter-args "-i"
;;    (elpy-enable)
;;    (pyvenv-workon "python")
;;    (remove-hook 'flymake-diagnostic-functions 'flymake-proc-legacy-flymake) ;;;;关闭flymake的错误提示。
    ;;(setq exec-path (append exec-path '("~/.local/bin/")));;;;;缺少这段会产生无法找到命令的情况。
;;    (setenv "PATH" (concat (getenv "PATH") ":" "~/.local/bin/"));;;Elpy安装在ArchLinux必需的代码，    
;;    (add-to-list 'exec-path (expand-file-name "~/.local/bin"))

(message "Init-python...DONE")
(provide 'init-python)

;;; init-python.el ends here
