;;==========org-mode ==========
(use-package org
  :ensure t
  :defer t
  :mode ("\\.org\\'" . org-mode) ;;扩展名为.org时启动org-mode
  :interpreter ("org" . org-mode)
  :bind
  (:map org-mode-map
        ("C-c f" . org-publish-current-file)
        ("C-c p" . org-publish-project)
        ("C-c b" . org-publish-all))
  :init
  (add-hook 'org-mode-hook (lambda ()
                             (setq-local electric-pair-inhibit-predicate
                                         `(lambda (c)
                                            (if (char-equal c ?<) t (,electric-pair-inhibit-predicate c))))))
  :config
  (message "Loading Org-mode...DONE"))

;; 不用自己输入 #+BEGIN_SRC…#+END_SRC 的Elisp 函数：
(defun org-insert-block (block-type)
  "Insert a block in org-mode."
  (interactive
   (let ((block-types
          '("quote" "example" "verse" "center" "comment"
            )))
     (list (ivy-completing-read "Block type: " block-types))))
(progn
    (newline-and-indent)
    (insert (format "#+begin_%s\n\n#+end_%s\n" block-type block-type))
    (previous-line 2)))
(add-hook 'org-mode-hook
          (lambda ()
            (setq truncate-lines nil)
            (local-set-key (kbd "C-c i")
                           'org-insert-block)))

(defun org-insert-src-block (src-code-type)
  "Insert a `SRC-CODE-TYPE' type source code block in org-mode."
  (interactive
   (let ((src-code-types
          '("emacs-lisp" "python" "C" "sh" "java" "js" "clojure" "C++" "css"
            "calc" "asymptote" "dot" "gnuplot" "ledger" "lilypond" "mscgen"
            "octave" "oz" "plantuml" "R" "sass" "screen" "sql" "awk" "ditaa"
            "haskell" "latex" "lisp" "matlab" "ocaml" "org" "perl" "ruby"
            "scheme" "sqlite")))
     (list (ido-completing-read "Source code type: " src-code-types))))
  (progn
    (newline-and-indent)
    (insert (format "#+BEGIN_SRC %s\n" src-code-type))
    (newline-and-indent)
    (insert "#+END_SRC\n")
    (previous-line 2)
    (org-edit-src-code)))

(add-hook 'org-mode-hook
          (lambda ()
            (setq truncate-lines nil)
            ;; turn on flyspell-mode by default
            ;; (flyspell-mode 1)
            ;; C-TAB for expanding
            ;; (local-set-key (kbd "C-<tab>")
            ;;               'yas/expand-from-trigger-key)
            
            ;; keybinding for editing source code blocks
            (local-set-key (kbd "C-c e")
                           'org-edit-src-code)
            ;; keybinding for inserting code blocks
            (local-set-key (kbd "C-c I")
                           'org-insert-src-block)

            ))
;; 函数结束

(setq org-html-htmlize-output-type 'css)
(setq org-html-validation-link nil)
(setq org-src-fontify-natively t) ;;#+begin_src 块中的语法突出显示
(setq org-src-tab-acts-natively t)
(setq org-link-search-must-match-exact-headline nil)
(eval-after-load "org"
  '(require 'ox-md nil t))


;; org-mode Blog
;; ==========org-publish==========
(use-package ox-publish
;;  :commands org-publish
  :after (org)
  :config
  (message "Ox-publish...DONE"))

;; ==========org-tempo==========
(use-package org-tempo
  :after (org)
  :config
  (message "Org-tempo...DONE"))

;; ==========htmlize==========
(use-package htmlize
  :ensure t
  :defer t
  :config
  (message "Htmlize...DONE"))

;; ==========org-superstar==========
(use-package org-superstar
  :ensure t
  :defer t
  :hook
  (org-mode . org-superstar-mode)
  :custom-face
  (org-superstar-header-bullet
   ((t (:family "DejaVu Sans Mono"))))
  (org-superstar-item
   ((t (:family "DejaVu Sans Mono"))))
  :config
  (setq org-superstar-leading-bullet "  ")
;;  (setq org-hide-leading-stars t)
  (message "Org-Superstar...DONE")
  )

;; ==========org-bullets==========
;;(use-package org-bullets
;;  :ensure t
;;  :defer t
;;  :hook
;;  (org-mode . org-bullets-mode)
;;  :config
;;  (message "Loading Org-bullets...DONE")
;;  )

;;(with-eval-after-load 'org
;;  (define-key org-mode-map (kbd "C-c f") 'org-publish-current-file)
;;  (define-key org-mode-map (kbd "C-c p") 'org-publish-project)
;;;;  (define-key org-mode-map (kbd "C-c b") (lambda () (interactive) (org-publish-project "blog")))
;;  (define-key org-mode-map (kbd "C-c b") 'org-publish-all)
;;
;;  )

(defun site-map-entry (entry style project)
  (when (not (directory-name-p entry))
    (format "[ %s ] - [[file:%s][%s]]"
    (format-time-string "%Y-%m-%d %H:%M"
                        (org-publish-find-date entry project))
    entry
    (org-publish-find-title entry project))
    ))

(setq-default org-display-custom-times t)
(setq org-time-stamp-custom-formats '("<%Y-%m-%d %A>"."<%Y-%m-%d %A %H:%M>"));;文档内的时间戳格式
(setq org-publish-use-timestamps-flag nil);强制发布所有文件，包括未更改的。

;;(setq org-publish-cache nil)
(setq org-html-home/up-format
      (concat "<div id=\"org-div-home-and-up\">\n <a accesskey=\"H\"
      href=\"%s\">归档</a>"
              "\n |\n "
              "<a accesskey=\"h\" href=\"%s\">首页
      </a>\n</div>"))
;;(setq org-html-link-up "sitemap.html")
;;(setq org-html-link-home "index.html")

;; 设置org文件目录
(setq yoursaf/org-dir "~/org/")
;; 设置发布目录
(setq yoursaf/publish-dir "/var/www/blog/")
;; 设置本地缓存目录
(setq org-publish-timestamp-directory
      (expand-file-name ".cache/" yoursaf/org-dir))


;; 设置preamble文件
(setq header-file-name
      (expand-file-name "res/preamble.html" yoursaf/org-dir))
;; 打开一个temp-buffer插入preamble文件
(defun yoursaf/header (arg)
  (with-temp-buffer
    (insert-file-contents header-file-name)
    (buffer-string)))

;; 设置html-postamble
(setq yoursaf/footer
      "<p>作者 &copy; %a </p>
<p>最后更新: %C </p>
<p>Built with %c </p>
<p><a href=\"https://beian.miit.gov.cn/\" target=\"_blank\">冀ICP备17032034号-1</a></p>"
      )

(setq org-publish-project-alist
      `(
        ("org"
         :base-directory ,yoursaf/org-dir
         :base-extension "org"
         :exclude "gtd\\|bsr\\|contents\\|ico\\|index\\|daily"
         :recursive t
         :html-extension "html"
         :makeindex t ;;生成索引文件
         :publishing-directory ,yoursaf/publish-dir
         :publishing-function org-html-publish-to-html
         :with-toc nil

         :auto-sitemap t                
         :sitemap-title "YoursAF InSide"
;;         :sitemap-filename "sitemap.org"
;;         :sitemap-filename "index.org"
         :sitemap-sort-folders ignore
         :sitemap-format-entry site-map-entry
         :sitemap-sort-files anti-chronologically
         :sitemap-style list
;;         :sitemap-function: org-publish-org-sitemap
;         :sitemap-ignore-case t ;; 区分大小写
;         :sitemap-date-format "%Y %B %e %H:%M" ;;设置时间格式
         
         :author "YoursAF"
         :email "yoursaf@163.com"
         :style-include-default nil
         :language "zh-CN"
         :html-doctype "html5"
         :section-numbers nil
         :table-of-contents nil
         :html-head "<link rel=\"stylesheet\" href=\"/res/css/blog.css\" type=\"text/css\"/>"
         :html-preamble yoursaf/header
         :html-postamble ,yoursaf/footer
         :html-link-up "/sitemap.html"
         :html-link-home "/index.html"
         )

        ("gtd"
         :base-directory ,(expand-file-name "gtd/" yoursaf/org-dir)
         :base-extension "org"

         :recursive t
         :html-extension "html"

         :publishing-directory ,(expand-file-name "gtd/" yoursaf/publish-dir)
         :publishing-function org-html-publish-to-html
         :with-toc nil

         :author "YoursAF"
         :email "yoursaf@163.com"
         :style-include-default nil
         :language "zh-CN"
         :html-doctype "html5"
         :section-numbers nil
         :table-of-contents nil
         :html-head "<link rel=\"stylesheet\" href=\"/res/css/blog.css\" type=\"text/css\"/>"
         :html-preamble yoursaf/header
         :html-postamble ,yoursaf/footer
;;         :html-postamble ,(with-temp-buffer (insert-file-contents "~/org/static/postamble.html") (buffer-string))
         :html-link-up "/sitemap.html"
         :html-link-home "/index.html"

         )

        ("bsr"
         :base-directory ,(expand-file-name "articles/bsr/" yoursaf/org-dir)
         :base-extension "org"

         :recursive t
         :html-extension "html"
         :makeindex t ;;生成索引文件
         
         :publishing-directory ,(expand-file-name "articles/bsr/" yoursaf/publish-dir)
         :publishing-function org-html-publish-to-html
         :with-toc nil
         
         :author "YoursAF"
         :email "yoursaf@163.com"
         :style-include-default nil
         :language "zh-CN"
         :html-doctype "html5"
         :section-numbers nil
         :table-of-contents nil
         :html-head "<link rel=\"stylesheet\" href=\"/res/css/blog.css\" type=\"text/css\"/>"
         :html-preamble yoursaf/header
         :html-postamble ,yoursaf/footer
;;         :html-postamble ,(with-temp-buffer (insert-file-contents "~/org/static/postamble.html") (buffer-string))
         :html-link-up "/sitemap.html"
         :html-link-home "/index.html"
         )

        ("photography"
         :base-directory ,(expand-file-name "articles/photography/" yoursaf/org-dir)
         :base-extension "org"

         :recursive t
         :html-extension "html"
         :makeindex t ;;生成索引文件
         
         :publishing-directory ,(expand-file-name "articles/photography/" yoursaf/publish-dir)
         :publishing-function org-html-publish-to-html
         :with-toc nil
         
         :author "YoursAF"
         :email "yoursaf@163.com"
         :style-include-default nil
         :language "zh-CN"
         :html-doctype "html5"
         :section-numbers nil
         :table-of-contents nil
         :html-head "<link rel=\"stylesheet\" href=\"/res/css/blog.css\" type=\"text/css\"/>"
         :html-preamble yoursaf/header
         :html-postamble ,yoursaf/footer
;;         :html-postamble ,(with-temp-buffer (insert-file-contents "~/org/static/postamble.html") (buffer-string))
         :html-link-up "/sitemap.html"
         :html-link-home "/index.html"
         )
        ("index"
         :base-directory ,yoursaf/org-dir
         :base-extension "org"
         :exclude ".*"
         :include ["index.org"]
         :html-extension "html"
         :publishing-directory ,yoursaf/publish-dir
         :publishing-function org-html-publish-to-html
         :with-toc nil
         
         :author "YoursAF"
         :email "yoursaf@163.com"
         :style-include-default nil
         :language "zh-CN"
         :html-doctype "html5"
         :section-numbers nil
         :table-of-contents nil
         :html-head "<link rel=\"stylesheet\" href=\"/res/css/blog.css\" type=\"text/css\"/>"
         :html-preamble yoursaf/header
         :html-postamble ,yoursaf/footer
         :html-link-up "/sitemap.html"
         :html-link-home "/index.html"
         )

        ("contents"
         :base-directory ,(expand-file-name "articles/contents/" yoursaf/org-dir)
         :base-extension "org"

         :recursive t
         :html-extension "html"

         :publishing-directory ,(expand-file-name "articles/contents/" yoursaf/publish-dir)
         :publishing-function org-html-publish-to-html
         :with-toc nil

         :author "YoursAF"
         :email "yoursaf@163.com"
         :style-include-default nil
         :language "zh-CN"
         :html-doctype "html5"
         :section-numbers nil
         :table-of-contents nil
         :html-head "<link rel=\"stylesheet\" href=\"/res/css/blog.css\" type=\"text/css\"/>"
         :html-preamble yoursaf/header
         :html-postamble ,yoursaf/footer
;;         :html-postamble ,(with-temp-buffer (insert-file-contents "~/org/static/postamble.html") (buffer-string))
         :html-link-up "/sitemap.html"
         :html-link-home "/index.html"
         )                

        ("res"
          :base-directory ,(expand-file-name "res/" yoursaf/org-dir)
          :base-extension ".*"
;;          :base-extension "css\\|js\\|png\\|jpg\\|gif\\|pdf\\|mp3\\|ogg\\|swf\\|el\\|html\\|ico"
          :publishing-directory ,(expand-file-name "res/"yoursaf/publish-dir)
          :recursive t
          :publishing-function org-publish-attachment
          )

         ("daily"
          :base-directory ,(expand-file-name "daily/" yoursaf/org-dir)
          :base-extension "org"
;;         :exclude "head"
          :recursive t
          :html-extension "html"
          :makeindex t
          :publishing-directory ,(expand-file-name "daily/" yoursaf/publish-dir)
          :publishing-function org-html-publish-to-html
          :with-toc nil
          :with-drawers t
          :author "YoursAF"
          :email "yoursaf@163.com"
          :style-include-default nil
          :language "zh-CN"
          :html-doctype "html5"
          :section-numbers nil
          :table-of-contents nil
          :html-head "<link rel=\"stylesheet\" href=\"/res/css/blog.css\" type=\"text/css\"/>"
          :html-preamble yoursaf/header
          :html-postamble ,yoursaf/footer
;;         :html-postamble ,(with-temp-buffer (insert-file-contents "~/org/static/postamble.html") (buffer-string))
          :html-link-up "/sitemap.html"
          :html-link-home "/index.html"
          )

        ("blog"
         :components ("org","gtd","bsr","photography","index","contents","res","daily"))
         )
      )

;;==========TODO==========
(setq org-agenda-files '("~/org/gtd/inbox.org"
                         "~/org/gtd/todo.org"
                         "~/org/gtd/journal.org"
                         "~/org/gtd/done.org"
                         ))
(setq org-default-notes-file "~/org/gtd/inbox.org")

;(setq org-log-done 'time);任务变为DONE状态时记录时间
(setq org-log-done 'note);任务变为DONE状态时记录日志

(global-set-key "\C-ca" 'org-agenda)
(with-eval-after-load 'org
(define-key org-mode-map "\C-cc" 'org-capture))

(setq org-capture-templates
      '(
        ("i" "InBox[inbox.org:构思]" entry (file
                                            "~/org/gtd/inbox.org") 
         "* %^{构思} %u\n%?" :empty-lines 1 :unnarrowed 1 :prepend t)
        ("s" "Schedule[todo.org:日程]" entry (file+headline
                                               "~/org/gtd/todo.org" "Schedule")
         "** %^{日程安排}u [/]\n+ [ ] %?" :prepend t)
        ("t" "TODO[todo.org：待办]")
        ("ts" "Schedule[todo.org:日程]" entry (file+headline
                                              "~/org/gtd/todo.org" "Schedule")
                 "%^{日程安排}u [/]\n+ [ ] %? %i\n"  :prepend t)
        ("tp" "Project[gtd.org:项目]" entry (file+headline
                                             "~/org/gtd/todo.org" "Projects")
         "** %^{任务名称} %u [/]\n%?" :empty-lines 1 :prepend t)
        ("tt" "Tasks[gtd.org:任务]" entry (file+headline
                                           "~/org/gtd/todo.org" "Tasks")
         "** %^{任务名称} %u [/]\n%?" :empty-lines 1 :prepend t)
        ("j" "Journal[journal.org:日志]"entry (file+headline
                                               "~/org/gtd/journal.org" "Journal")
         "* %^{工作日志}u \n %? %i\n" :empty-lines 1 :prepend t)
        ("d" "Diary[diary.org:日记]" entry (file+regexp
                                            "~/org/diary/diary.org" "^\\*\\s-[[:digit:]]\\{4\\}\\cc[[:digit:]]\\{1,2\\}\\cc$")
         "* %^u %^g\n\n%?\n" :empty-lines 1 :prepend t)
        ))

(setq org-refile-targets '(("~/org/gtd/todo.org" :maxlevel . 1)
                           ("~/org/gtd/inbox.org" :level . 1)
                           ("~/org/gtd/done.org" :maxlevel . 1)
;                           ("~/org/gtd/trash.org" :maxlevel . 1)
;                           ("~/org/gtd/watting.org" :maxlevel . 1)
                           ("~/org/gtd/journal.org" :maxlevel . 1)
                           ))
(setq org-todo-keywords
      '(
        ;;        (type "工作(w)" "人际关系(p)" "读书(r)" "学习(s)" "|" "DONE")
        (sequence "TODO(t)" "NEXT(n)" "PAUSE(p)" "|" "DONE(d)")
        ;;        (sequence "Processing(p@)" "Watting(w@)" "Someday(s@)""|" "Abort(a)")
        (sequence "|" "ABORT(a)" "CANCELED(c)")
        ))
(setq org-tag-alist '(("项目" . ?p) ("任务" . ?t) ("读书" . ?r) ("学习" . ?s)))

(message "Init-org...DONE")
(provide 'init-org)

;;; init-org.el ends here
