;; ==========10.ido-mode==========
(use-package ido
  :ensure t
  :defer t
  :config
  (ido-mode 1)
  (progn
    (make-local-variable 'ido-decorations)
    (setf (nth 2 ido-decorations) "\n"))
  ;; show any name that has the chars you typed
  (setq ido-enable-flex-matching t)
  ;; use current pane for newly opened file
  (setq ido-default-file-method 'selected-window)
  ;; use current pane for newly switched buffer
  (setq ido-default-buffer-method 'selected-window)
  ;; stop ido from suggesting when naming new file
  (define-key (cdr ido-minor-mode-map-entry) [remap write-file] nil)
  ;; ido save file
  (setq ido-save-directory-list-file (locate-user-emacs-file ".ido.last"))

  )

(message "Loading ido...DONE")
(provide 'init-ido)

;;; init-ido.el ends here
