;;; init-ibuffer.el --- ibuffer settings -*- lexical-binding: t -*-
;;; Code:
(use-package ibuffer
  :defer t
  :config
;;  (fullframe ibuffer ibuffer-quit)
  (setq ibuffer-expert t
        ibuffer-show-empty-filter-groups nil
        ibuffer-filter-group-name-face 'font-lock-doc-face
        ;; 不显示最下方的摘要信息
        ;;           ibuffer-display-summary nil
        )
;;(use-package fullframe
;;  :ensure t
;;  :after (ibuffer)
;;  :config
;;  (message "Loading Fullframe...DONE")
;;  )
  (use-package ibuffer-vc
    :ensure t
    :defer t
    :config
    (message "Loading Ibuffer-vc...DONE")
    )

  ;;(eval-after-load 'ibuffer
  ;;            (fullframe ibuffer ibuffer-quit))

  (setq-default ibuffer-show-empty-filter-groups nil)

  ;; Use human readable Size column instead of original one
  (define-ibuffer-column size-h
    (:name "Size" :inline t)
    (file-size-human-readable (buffer-size)))

  ;; Regroup files with their major mode.
  (eval-after-load 'ibuffer
    '(progn  
       (setq ibuffer-saved-filter-groups
             (quote ((
                      "default" (or (name . "^\\*scratch\\*$")
                                    (name . "^\\*Messages\\*$"))
                      ("Org-mode" (or
                                   (name . "^\\*Calendar\\*$")
                                   (name . "^diary$")
                                   (mode . org-mode)
                                   (mode . org-agenda-mode)
                                   ))
                      ("Python" (mode . python-mode))
                      ("Emacs-lisp" (mode . emacs-lisp-mode))
                      ("code" (or (mode . cperl-mode)
                                  (mode . c-mode)
                                  (mode . java-mode)
                                  (mode . idl-mode)
                                  (mode . lisp-mode)
                                  (mode . c++-mode)
                                  (mode . cmake-mode)
                                  (mode . css-mode)
                                  (mode . php-mode)
                                  (mode . sh-mode)
                                  (mode . json-mode)
                                  (mode . scala-mode)
                                  (mode . fvwm-mode)
                                  ))
                      ("dired" (or (mode . dired-mode)
                                   (mode . sr-mode)
                                   ))
                      ))))
       (add-hook 'ibuffer-mode-hook (lambda ()
                                      (ibuffer-vc-set-filter-groups-by-vc-root)
                                      (unless (eq ibuffer-sorting-mode 'filename/process)
                                        (ibuffer-do-sort-by-filename/process))
                                      (ibuffer-switch-to-saved-filter-groups "default")
                                      ))
       ))
  ;; Display icons with all-the-icons.
  (define-ibuffer-column icon (:name "  ")
    (let ((icon (if (and (buffer-file-name)
                         (all-the-icons-auto-mode-match?))
                    (all-the-icons-icon-for-file
                     (file-name-nondirectory (buffer-file-name))
                     :v-adjust -0.10 :height 0.8)
                  (all-the-icons-icon-for-mode major-mode :v-adjust -0.10 :height 0.8 :face: 'all-the-icons-dsilver))))
      (if (symbolp icon)
          (setq icon (all-the-icons-faicon "file-o"
                                           :face 'all-the-icons-dsilver
                                           :v-adjust 0.0))
        icon)))

  ;; Modify the default ibuffer-formats (toggle with `)
  (setq ibuffer-formats
        '((mark modified read-only vc-status-mini " "
                (icon 2 2 :left :elide)
                " "
                (name 22 22 :left :elide)
                " "
                (size-h 9 -1 :right)
                " "
                (mode 12 12 :left :elide)
                " "
                filename-and-process)
          
          (mark modified read-only vc-status-mini " "
                (icon 2 2 :right :elide)
                " "
                (name 22 22 :left :elide)
                " "
                (size-h 9 -1 :right)
                " "
                (mode 14 14 :left :elide)
                " "
                (vc-status 12 12 :left)
                " "
                filename-and-process)
          ))
  (message "Loading Ibuffer...DONE"))

(message "Init-ibuffer...DONE")
(provide 'init-ibuffer)

;;; init-ibuffer.el ends here
