;;;=============================界面和全局设置=============================

;;==========启动设置==========
;; 启动时最大化
(add-to-list 'default-frame-alist '(fullscreen . maximized))
;;=====透明度设置=====
;; 设置默认帧的 alpha：焦点 100%，非焦点 80%
(when (display-grayscale-p)
  (add-to-list 'default-frame-alist '(alpha . (100 . 90)))
  )
;; 应用到当前帧（重启后自动生效）
(add-hook 'after-init-hook
          (lambda ()
            (when (display-graphic-p)  ; 只在 GUI 模式
              (set-frame-parameter nil 'alpha '(100 . 90)))))
;; 从 frameset 中排除透明度相关参数，避免错误
(cond ((eq system-type 'windows-nt)
       (with-eval-after-load 'frameset
         (dolist (param '(alpha alpha-background))
           (add-to-list 'frameset-filter-alist
                        `(,param . frameset-filter-alist-ignore))))))
;; (split-window-right)
;; (other-window 1)
;; (split-window-below)

;;==========字体设置==========
(when (display-graphic-p)
(cond
 ((eq system-type 'gnu/linux)
  (add-to-list 'default-frame-alist '(font . "Adwaita Mono-12:Regular"))  
;;  (add-to-list 'default-frame-alist '(font . "SF Mono-12:Regular"))
;;  (add-to-list 'default-frame-alist '(font . "Fira Code-12:Regular"))
  ;;=====汉字字体=====
  (set-fontset-font t 'han "HarmonyOS Sans SC")
  ;;=====默认目录=====
  (setq default-directory "~/"))
 ((eq system-type 'windows-nt)
  (add-to-list 'default-frame-alist '(font . "Rec Mono Linear-12"))
;;  (add-to-list 'default-frame-alist '(font . "Roboto Mono-12"))
;;  (add-to-list 'default-frame-alist '(font . "DM Mono-12:Regular"))
  ;;=====汉字字体=====
  (set-fontset-font t 'han "LXGW WenKai Mono Lite")
  ;;=====默认目录=====
  (setq default-directory "D:/"))
 )
  )
;;=====汉字字体=====
;;(when (display-graphic-p)
;;  (cond
;;   ((eq system-type 'gnu/linux)
;;    (set-fontset-font t 'han "HarmonyOS Sans SC"))
;;   ((eq system-type 'windows-nt)
;;    (set-fontset-font t 'han "LXGW WenKai Mono Lite"))
;;  ))

;;(set-fontset-font "fontset-default" 'han "HarmonyOS Sans SC")
;;(set-fontset-font t 'han "LXGW WenKai Mono Lite")

;; =====Unicode Symbols字体=====
(set-fontset-font
 t
 'symbol
 (cond
  ((eq system-type 'gnu/linux)
   (cond
    ((member "Symbola" (font-family-list)) "Symbola")))
  ((eq system-type 'windows-nt)
   (cond
    ((member "Segoe UI Symbol" (font-family-list)) "Segoe UI Symbol")))
  ((eq system-type 'darwin)
   (cond
    ((member "Apple Symbols" (font-family-list)) "Apple Symbols")))
  ))
;;(set-fontset-font t 'symbol "DejaVu Sans Mono")


;;(remove-hook 'kill-emacs-hook 'keyfreq-mustsave--do)))
;;(setq initial-buffer-choice (switch-to-buffer "*Messages*"))

;;TAB插入空格
(setq-default indent-tabs-mode nil)
;;当前行长度超过fill-coulmn值后，输入回车或者空格，则从上一个断开符号自动折行。
(setq-default fill-column 80);80个字符自动换行

;;值为nil或未设置时，如果当前行内容过长，则在显示到边界后自动切换到下一行显示。
;;但并未加入换行符，只是在新一行显示当前行内容。
;;(set-default 'truncate-lines t);关闭自动换行功能
;;(setq-default major-mode 'text-mode);转为模式为text-mode
;;(add-hook 'org-mode-hook 'turn-off-auto-fill);;关闭org-mode的auto-fill(自动折行)功能
;;(add-hook 'python-mode-hook 'turn-on-auto-fill)
;;(add-hook 'text-mode-hook 'turn-on-auto-fill)
;;be smart about file names in mini buffer
;;(ansi-color-for-comint-mode-on);eshell乱码
;;(windmove-default-keybindings);开启使用S+方向键选择window

(prefer-coding-system 'utf-8)
(set-default-coding-systems 'utf-8)
(set-terminal-coding-system 'utf-8)
(set-keyboard-coding-system 'utf-8)

;;=====Tramp设置=====
;; Windows下tramp无法访问sshx时，应用这些配置
(when (eq system-type 'windows-nt)
  ;; 禁用 SSH ControlMaster（Windows不支持）
  (setq tramp-use-ssh-controlmaster-options nil)
  ;; 关闭Windows下提示无法压缩
  (setq tramp-inline-compress-start-size nil)
  )
;; Tramp Faster than the default scp
(setq tramp-default-method "sshx")

;(customize-set-variable 'ido-enable-tramp-completion nil)
;(customize-set-variable 'tramp-syntax 'simplified)

;; 用"y/n"替换"yes/no"
;;(defalias 'yes-or-no-p 'y-or-n-p)
(setopt use-short-answers t)
(setq auto-mode-alist (cons '("[^/]\\.dired$" . dired-virtual-mode)
                            auto-mode-alist))

;;================================自动补全
(setq hippie-expand-try-functions-list
      '(
        try-expand-line ; 补全当前行
        try-expand-line-all-buffers
        try-expand-list ; 补全一个列表
        try-expand-list-all-buffers
        try-expand-dabbrev ; 搜索当前 buffer
        try-expand-dabbrev-visible ; 搜索当前可见窗口
        try-expand-dabbrev-all-buffers ; 搜索所有 buffer
        try-expand-dabbrev-from-kill ; 从 kill-ring 中搜索
        try-complete-file-name ; 文件名匹配
        try-complete-file-name-partially ; 文件名部分匹配
        try-complete-lisp-symbol ; 补全 lisp symbol
        try-complete-lisp-symbol-partially ; 部分补全 elisp symbol
        try-expand-whole-kill
        ))
(global-set-key [(meta ?/)] 'hippie-expand)
;;(global-set-key (kbd "M-/") #'hippie-expand)

(message "Init-global...DONE")
(provide 'init-global)

;;; init-global.el ends here
