;; ==========14.company-mode==========
(use-package company
  :ensure t
  ;;    :defer t
  :hook (after-init . global-company-mode)
  :hook (prog-mode . company-mode)
  ;;    :after (:any ivy ido)
  :diminish
  (company-mode "COMP")
  ;;    :init
  ;;   (add-hook 'after-init-hook #'global-company-mode)
  :bind (:map company-active-map
              ("\e" . company-abort))
  :config
  ;;    (global-company-mode)
  ;;    (define-key company-active-map (kbd "<escape>") 'company-abort)
  (setq company-dabbrev-downcase nil
        ;; make previous/next selection in the popup cycles
        company-selection-wrap-around t
        ;; Some languages use camel case naming convention,
        ;; so company should be case sensitive.
        company-dabbrev-ignore-case nil
        ;; press M-number to choose candidate
        company-show-numbers t
        company-idle-delay 0.2
        company-clang-insert-arguments nil
        company-require-match nil
        company-ctags-ignore-case t
        company-tooltip-align-annotations t
        company-minimum-prefix-length 2
        ;;company-auto-complete t
        )
  (set-face-foreground 'company-tooltip "gray50")
  (set-face-background 'company-tooltip "gray20")
  (set-face-foreground 'company-tooltip-common "chocolate")
  (set-face-foreground 'company-tooltip-selection "lightgray")
  (set-face-background 'company-tooltip-selection "DodgerBlue4")
  (set-face-foreground 'company-tooltip-common-selection "#00C864"))
  ;;    (set-face-background 'company-scrollbar-bg "darkgray")
  ;;    (set-face-background 'company-scrollbar-fg "black")
  ;;    (set-face-foreground 'company-tooltip-annotation "gray40")
  ;;    (set-face-foreground 'company-tooltip-annotation-selection "white")
  ;;    (set-face-foreground 'company-tooltip-search "red")

;; ==========company-box==========
(use-package company-box
  :ensure t
  :after company
  :diminish
  (company-box-mode nil)
  ;;    :if window-system
  :hook
  (company-mode . company-box-mode)
  :config
  (setq company-box-icons-alist 'company-box-icons-all-the-icons)
  (setq company-box-doc-delay 1)
  (setq company-box-backends-colors
        '(
          (company-yasnippet . (:all "lime green" :selected (:background "lime green" :foreground "black"))))))

(message "Loading Company-mode...DONE")
(provide 'init-company)

;;; init-company.el ends here
